function xdot = extremumswarming_doubleno2_derivative(t, x)

global M wx ax cx wy ay cy h zx px kx zy py ky flag
global ux1save uy1save ux2save uy2save ux3save uy3save tsave;

% variable matrix
% A1 A2 A3 T
% xp        xt
% yp        yt
% vx
% vy
% pdx
% pdy
% eta

% disturbance amplitude
ar=0;

% target
xt=x(3*7+1);
yt=x(3*7+2);
tar_dot(1)=.25; 
tar_dot(2)=sin(0.25*t);

for i=1:M
    xp(i)=x(1+(i-1)*7); 
    yp(i)=x(2+(i-1)*7); 
    vx(i)=x(3+(i-1)*7); 
    vy(i)=x(4+(i-1)*7); 
   pdx(i)=x(5+(i-1)*7); 
   pdy(i)=x(6+(i-1)*7); 
   eta(i)=x(7+(i-1)*7);
end

% Computation of potential function  
J(1)=-potential(xp(1),yp(1),xp(2),yp(2),xp(3),yp(3),xt,yt);
J(2)=-potential(xp(2),yp(2),xp(1),yp(1),xp(3),yp(3),xt,yt);
J(3)=-potential(xp(3),yp(3),xp(2),yp(2),xp(1),yp(1),xt,yt);



for i=1:M
    ux(i)=-ax(i)*wx(i)*wx(i)*sin(wx(i)*t)+pdx(i)+(kx(i)*cx(i)*sin(wx(i)*t)*(J(i)-eta(i)));
    uy(i)=ay(i)*wy(i)*wy(i)*cos(wy(i)*t)+pdy(i)+(ky(i)*cy(i)*(-cos(wy(i)*t))*(J(i)-eta(i)));
end

for i=1:M
    xdot(1+(i-1)*7)=vx(i); 
    xdot(2+(i-1)*7)=vy(i); 
    xdot(3+(i-1)*7)=ux(i)+ar*sin(0.2*t);%*rand; 
    xdot(4+(i-1)*7)=uy(i)+ar*sin(0.2*t);%*rand; 
    xdot(5+(i-1)*7)=px(i)*pdx(i)+(px(i)-zx(i))*(kx(i)*cx(i)*sin(wx(i)*t)*(J(i)-eta(i)));
    xdot(6+(i-1)*7)=py(i)*pdy(i)+(py(i)-zy(i))*(ky(i)*cy(i)*(-cos(wy(i)*t))*(J(i)-eta(i)));
    xdot(7+(i-1)*7)=h(i)*(J(i)-eta(i));
end

% Target dynamics
xdot(22:23) = tar_dot(:);
xdot(24:28)=0;

xdot = xdot';  %'

tsave = [tsave;t];
ux1save = [ux1save;ux(1)];
uy1save = [uy1save;uy(1)];
ux2save = [ux2save;ux(2)];
uy2save = [uy2save;uy(2)];
ux3save = [ux3save;ux(3)];
uy3save = [uy3save;uy(3)];
 
 
 